<?php
include 'includes/header.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

// Handle brand operations
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_brand'])) {
        $name = sanitize_input($_POST['name']);
        $query = "INSERT INTO brands (name) VALUES (?)";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$name])) {
            set_message('Brand added successfully');
        } else {
            set_message('Error adding brand', 'danger');
        }
    }

    if (isset($_POST['edit_brand'])) {
        $id = $_POST['brand_id'];
        $name = sanitize_input($_POST['name']);
        $query = "UPDATE brands SET name = ? WHERE id = ?";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$name, $id])) {
            set_message('Brand updated successfully');
        } else {
            set_message('Error updating brand', 'danger');
        }
    }

    if (isset($_POST['delete_brand'])) {
        $id = $_POST['brand_id'];
        $query = "DELETE FROM brands WHERE id = ?";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$id])) {
            set_message('Brand deleted successfully');
        } else {
            set_message('Error deleting brand', 'danger');
        }
    }
}

// Get all brands with model count
$brands_query = "SELECT b.*, COUNT(m.id) as model_count 
                 FROM brands b 
                 LEFT JOIN models m ON b.id = m.brand_id 
                 GROUP BY b.id 
                 ORDER BY b.name";
$brands = $db->query($brands_query)->fetchAll();
?>

<div class="container py-4">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2>Manage Brands</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="./manage_cars.php" class="btn btn-primary">
                <i class="fas fa-plus"></i> Cars
            </a>
            <a href="./manage_models.php" class="btn btn-primary">
                <i class="fas fa-plus"></i> Models
            </a>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addBrandModal">
                <i class="fas fa-plus"></i> Add New Brand
            </button>
        </div>
    </div>

    <div class="card shadow">
        <div class="card-body" style="max-height: 70vh; overflow-y: auto;">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Brand Name</th>
                            <th>Models</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($brands as $brand): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($brand['name']); ?></td>
                                <td><?php echo $brand['model_count']; ?></td>
                                
                                <td>
                                    <button type="button" 
                                            class="btn btn-sm btn-primary edit-brand"
                                            data-id="<?php echo $brand['id']; ?>"
                                            data-name="<?php echo htmlspecialchars($brand['name']); ?>"
                                            data-bs-toggle="modal"
                                            data-bs-target="#editBrandModal">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <form method="POST" class="d-inline" 
                                          onsubmit="return confirm('Are you sure? This will also delete all associated models.');">
                                        <input type="hidden" name="brand_id" value="<?php echo $brand['id']; ?>">
                                        <button type="submit" name="delete_brand" class="btn btn-sm btn-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Add Brand Modal -->
<div class="modal fade" id="addBrandModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Brand</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Brand Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="add_brand" class="btn btn-primary">Add Brand</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Brand Modal -->
<div class="modal fade" id="editBrandModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Brand</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="brand_id" id="edit-brand-id">
                    <div class="mb-3">
                        <label class="form-label">Brand Name</label>
                        <input type="text" class="form-control" name="name" id="edit-brand-name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="edit_brand" class="btn btn-primary">Update Brand</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Edit Brand Modal Handler
document.querySelectorAll('.edit-brand').forEach(button => {
    button.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        const name = this.getAttribute('data-name');
        
        document.getElementById('edit-brand-id').value = id;
        document.getElementById('edit-brand-name').value = name;
    });
});
</script>
<?php include '../includes/footer.php'; ?> 

